-- AddTool by eyeon software
-- blazej floch: Modified
-- 22-Oct-09, daniel koch: List restriction
-- 31-Mar-11, daniel koch: Added Macros:
-- 24-Jun-11, daniel: Fixed macro subdirs, removed .setting, supports multipath Macro:
-- 18-Jul-11, daniel: Now rescans Macro: each time, and uses comp:MapPathSegments() to handle multipath, multilevel mappings
--  6-Sep-11, daniel: Minor bugfix

-- constants
MacroID = "**Macro"

function AddMacroDir(tbl, path)
	local macrodir = bmd.readdir(path.."*")

	for i,v in ipairs(macrodir) do
		if v.IsDir then
			AddMacroDir(tbl, path..v.Name.."\\")
		elseif string.lower(string.sub(v.Name, -8)) == ".setting" then
			local entry = {}
			entry.REGS_Name = string.sub(v.Name, 1, #v.Name - 8)
			entry.REGS_OpIconString = "Macro"
			entry.REGS_ID = MacroID
			entry.Path = path..v.Name

			table.insert(tbl, entry)
		end
	end
end

function CopyTable(t)
  local t2 = {}
  for k,v in pairs(t) do
    t2[k] = v
  end
  return t2
end

-- Cache tool names and IDs first time round, to avoid delays
if globals.__addtool_data then
	alltools = CopyTable(globals.__addtool_data)
else
	alltools = fu:GetRegSummary(CT_Tool)
	
	-- Fill in missing entries
	for i,v in ipairs(alltools) do
		-- If there is no Name use the OpIconString if available
		if not v.REGS_Name then
			if not v.REGS_OpIconString then
				v.REGS_Name = "???"
			else
				v.REGS_Name = v.REGS_OpIconString
			end
		end
		
		-- If there is no OpIconString use the first 4 letter of the Name if available
		if not v.REGS_OpIconString then
			if not v.REGS_Name then
				v.REGS_OpIconString = "???"
			else
				v.REGS_OpIconString = string.sub(v.REGS_Name, 0, 4)
			end
		end
	end

	alltools.lasttool = 1

	globals.__addtool_data = CopyTable(alltools)
end

-- Rescan and re-add macros each time, in case they change
local path
if comp.MapPathSegments then
	local paths = comp:MapPathSegments("Macros:")

	for k,v in ipairs(paths) do
		AddMacroDir(alltools, v.."\\")
	end
else
	path = comp:MapPath("Macros:\\")
end

local tools = alltools

local otherfield = { REGS_Name = "REGS_OpIconString", REGS_OpIconString = "REGS_Name" }


function UpdateList(list, data)
	table.sort(data, function(a,b) return (a.REGS_Name < b.REGS_Name) end)
	
	list[1] = nil		-- clears the list
	for i,v in ipairs(data) do
		list[tostring(i)] = v.REGS_Name .. " (" .. v.REGS_OpIconString .. ")"
	end
end


-- Define our UI
local toolid = nil

local toollist = iup.list{expand="HORIZONTAL", size="x200", dropdown="NO"}

UpdateList(toollist, tools)

local toolname = iup.text{"",	expand="HORIZONTAL"}
local ok = iup.button{title = "OK", size=50, expand="NO", fgcolor=iup.GetGlobal("DLGFGCOLOR")}
local cancel = iup.button{title = "Cancel", size=50, expand="NO", fgcolor=iup.GetGlobal("DLGFGCOLOR")}

local dlg = iup.dialog
{
	title = "Add Tool",
	foreground = "YES",
	margin = "10x10",
	defaultenter = ok, defaultesc = cancel,
	border = "NO", minbox = "NO", maxbox = "NO", menubox = "NO", resize = "NO",
	bgcolor = "52 52 52", fgcolor = "192 192 192",
	startfocus = toolname,
	
	iup.vbox
	{
		toollist,
		toolname,
		iup.fill{size=5},
		iup.hbox
		{
			margin = "0x0",
			ok,	iup.fill{SIZE=50}, cancel,
		},
	},
}

iup.SetAttribute(dlg, "NATIVEPARENT", touserdata(fu:GetMainWindow()))

function moveselection(num)
	movetoselection(num + toollist.value)
end

function movetoselection(num)
	num = math.min(math.max(1, num), #tools)
	toollist.value = num
	v = toollist[num]
	toolname.value = tools[num].REGS_Name
	toolname.selection = "1:1000"
end

function restrictlist(fromlist, text)
	local tolist = {}
	local lowtext = string.lower(text)
	local listsize = 0
	local i,v

	-- restrict list to only those containing our text
	for i,v in ipairs(fromlist) do
		local lowname = string.lower(v.REGS_Name)
		if string.find(lowname, lowtext)								-- search the name
		  or string.find(string.lower(v.REGS_OpIconString), lowtext)	-- search the icon string
		  or string.find(string.gsub(lowname, " ", ""), lowtext) then	-- search the name with spaces removed
			listsize = listsize + 1
			tolist[listsize] = v
		end
	end
	
	UpdateList(toollist, tolist)

	-- now select one
	if listsize > 0 then
		local len = string.len(text)
		local sel = 0
		
		-- look for a match at the start of the name
		for i,v in ipairs(tolist) do
			if string.lower(string.sub(v.REGS_Name,1,len)) == lowtext then
				sel = i
				break
			end
		end
		
		if sel == 0 then
			-- look for a match at the start of the icon string
			for i,v in ipairs(tolist) do
				if string.lower(string.sub(v.REGS_OpIconString,1,len)) == lowtext then
					sel = i
					break
				end
			end
		end

		if sel == 0 then
			sel = 1
		end
		toollist.value = tostring(sel)
	end

	return tolist
end

function toolname:action(key, text)
	if string.len(text) > 0 then
		tools = restrictlist(alltools, text)
	else
		tools = alltools
		UpdateList(toollist, tools)
		self.value = ""
	end
end

function toolname:k_any(key)
	if key == iup.K_UP then
		moveselection(-1)
	elseif key == iup.K_PGUP then
		moveselection(-10)
	elseif key == iup.K_cPGUP then
		movetoselection(1)
	elseif key == iup.K_cHOME then
		tools = alltools
		UpdateList(toollist, tools)
		movetoselection(1)
	elseif key == iup.K_DOWN then
		moveselection(1)
	elseif key == iup.K_PGDN then
		moveselection(10)
	elseif key == iup.K_cPGDN then
		movetoselection(#tools)
	elseif key == iup.K_cEND then
		tools = alltools
		UpdateList(toollist, tools)
		movetoselection(#tools)
	else
		return iup.CONTINUE
	end
	
	return iup.IGNORE
end

function toollist:action(text, item, sel)
	toolname.value = tools[item].REGS_Name
	toolname.selection = "1:1000"
	iup.SetFocus(toolname)
	
	return iup.DEFAULT
end

function toollist:dblclick_cb(pos, text)	-- not called?
	ok:action()
end

function ok:action()
	local num = tonumber(toollist.value)
	if num <= #tools and tools[num] then
		local id = tools[num].REGS_ID

		toolid = id;
		alltools.lasttool = id

		if id == MacroID then
			toolpath = tools[num].Path
		else
			toolpath = nil
		end

		return iup.CLOSE
	end
end

function cancel:action()
	return iup.CLOSE
end


-- start with last tool
local id = alltools.lasttool

for i,v in ipairs(tools) do
	if v.REGS_ID == id then
		toollist.value = i
		toolname.value = v.REGS_Name
		break
	end
end

dlg:show()

toolname.selection = "1:1000"

status,err = pcall(iup.MainLoop)

dlg:destroy()

-- Do the AddTool() after the iup dialog has closed, otherwise some fighting
-- over window focus happens, causing a deadlock within Windows
if toolid == MacroID then
	local tool = bmd.readfile(toolpath)
	if tool and tool["Tools"] ~= nil then
		comp:Paste(tool)
	end
elseif toolid ~= nil then
	local tool = comp:AddTool(toolid, true, -32768, -32768)
end

globals.__addtool_data.lasttool = alltools.lasttool

if not status then
	print(err)
end
